<?php
/**
 * Class that operate on table 'employeeclosedaygroupstatus'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-11-19 05:41
 */
class EmployeeclosedaygroupstatusMySqlDAO implements EmployeeclosedaygroupstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @return EmployeeclosedaygroupstatusMySql 
	 */
	public function load($id){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->getRow($sqlQuery);
	}

	/**
	 * Get all records from table
	 */
	public function queryAll(){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
	 * Get all records from table ordered by field
	 *
	 * @param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus ORDER BY '.$orderColumn;
		$sqlQuery = new SqlQuery($sql);
		return $this->getList($sqlQuery);
	}
	
	/**
 	 * Delete record from table
 	 * @param employeeclosedaygroupstatu primary key
 	 */
	public function delete($id){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($id);
		return $this->executeUpdate($sqlQuery);
	}
	
	/**
 	 * Insert record to table
 	 *
 	 * @param EmployeeclosedaygroupstatusMySql employeeclosedaygroupstatu
 	 */
	public function insert($employeeclosedaygroupstatu){
		$sql = 'INSERT INTO employeeclosedaygroupstatus (day, employeegroupid, status, userid, sysdate, conditions) VALUES (?, ?, ?, ?, ?, ?)';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeclosedaygroupstatu->day);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->employeegroupid);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->status);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->userid);
		$sqlQuery->set($employeeclosedaygroupstatu->sysdate);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->conditions);

		$id = $this->executeInsert($sqlQuery);	
		$employeeclosedaygroupstatu->id = $id;
		return $id;
	}
	
	/**
 	 * Update record in table
 	 *
 	 * @param EmployeeclosedaygroupstatusMySql employeeclosedaygroupstatu
 	 */
	public function update($employeeclosedaygroupstatu){
		$sql = 'UPDATE employeeclosedaygroupstatus SET day = ?, employeegroupid = ?, status = ?, userid = ?, sysdate = ?, conditions = ? WHERE id = ?';
		$sqlQuery = new SqlQuery($sql);
		
		$sqlQuery->set($employeeclosedaygroupstatu->day);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->employeegroupid);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->status);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->userid);
		$sqlQuery->set($employeeclosedaygroupstatu->sysdate);
		$sqlQuery->setNumber($employeeclosedaygroupstatu->conditions);

		$sqlQuery->setNumber($employeeclosedaygroupstatu->id);
		return $this->executeUpdate($sqlQuery);
	}

	/**
 	 * Delete all rows
 	 */
	public function clean(){
		$sql = 'DELETE FROM employeeclosedaygroupstatus';
		$sqlQuery = new SqlQuery($sql);
		return $this->executeUpdate($sqlQuery);
	}

	public function queryByDay($value){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByEmployeegroupid($value){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE employeegroupid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByStatus($value){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryByUserid($value){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}

	public function queryBySysdate($value){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->getList($sqlQuery);
	}

	public function queryByConditions($value){
		$sql = 'SELECT * FROM employeeclosedaygroupstatus WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->getList($sqlQuery);
	}


	public function deleteByDay($value){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE day = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByEmployeegroupid($value){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE employeegroupid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByStatus($value){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE status = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByUserid($value){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE userid = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteBySysdate($value){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE sysdate = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->set($value);
		return $this->executeUpdate($sqlQuery);
	}

	public function deleteByConditions($value){
		$sql = 'DELETE FROM employeeclosedaygroupstatus WHERE conditions = ?';
		$sqlQuery = new SqlQuery($sql);
		$sqlQuery->setNumber($value);
		return $this->executeUpdate($sqlQuery);
	}


	
	/**
	 * Read row
	 *
	 * @return EmployeeclosedaygroupstatusMySql 
	 */
	protected function readRow($row){
		$employeeclosedaygroupstatu = new Employeeclosedaygroupstatu();
		
		$employeeclosedaygroupstatu->id = $row['id'];
		$employeeclosedaygroupstatu->day = $row['day'];
		$employeeclosedaygroupstatu->employeegroupid = $row['employeegroupid'];
		$employeeclosedaygroupstatu->status = $row['status'];
		$employeeclosedaygroupstatu->userid = $row['userid'];
		$employeeclosedaygroupstatu->sysdate = $row['sysdate'];
		$employeeclosedaygroupstatu->conditions = $row['conditions'];

		return $employeeclosedaygroupstatu;
	}
	
	protected function getList($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		$ret = array();
		for($i=0;$i<count($tab);$i++){
			$ret[$i] = $this->readRow($tab[$i]);
		}
		return $ret;
	}
	
	/**
	 * Get row
	 *
	 * @return EmployeeclosedaygroupstatusMySql 
	 */
	protected function getRow($sqlQuery){
		$tab = QueryExecutor::execute($sqlQuery);
		if(count($tab)==0){
			return null;
		}
		return $this->readRow($tab[0]);		
	}
	
	/**
	 * Execute sql query
	 */
	protected function execute($sqlQuery){
		return QueryExecutor::execute($sqlQuery);
	}
	
		
	/**
	 * Execute sql query
	 */
	protected function executeUpdate($sqlQuery){
		return QueryExecutor::executeUpdate($sqlQuery);
	}

	/**
	 * Query for one row and one column
	 */
	protected function querySingleResult($sqlQuery){
		return QueryExecutor::queryForString($sqlQuery);
	}

	/**
	 * Insert row to table
	 */
	protected function executeInsert($sqlQuery){
		return QueryExecutor::executeInsert($sqlQuery);
	}
}
?>